<?php

if (!defined('ABSPATH')) {
    exit;
}

add_action('admin_menu', 'crocopay_settings_menu');

function crocopay_settings_menu() {
    add_menu_page('CrocoPay Settings', 'CrocoPay', 'manage_options', 'crocopay-settings', 'crocopay_settings_page');
}

function crocopay_settings_page() {
    ?>
    <div class="wrap">
        <h1>CrocoPay Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('crocopay-settings-group');
            do_settings_sections('crocopay-settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

add_action('admin_init', 'crocopay_settings_init');

function crocopay_settings_init() {
    register_setting('crocopay-settings-group', 'crocopay_api_key');
    register_setting('crocopay-settings-group', 'crocopay_search_engine_id');

    add_settings_section('crocopay_settings_section', 'General Settings', null, 'crocopay-settings');

    add_settings_field('crocopay_api_key', 'API Key', 'crocopay_api_key_callback', 'crocopay-settings', 'crocopay_settings_section');
    add_settings_field('crocopay_search_engine_id', 'Search Engine ID', 'crocopay_search_engine_id_callback', 'crocopay-settings', 'crocopay_settings_section');
}

function crocopay_api_key_callback() {
    $api_key = get_option('crocopay_api_key');
    echo "<input type='text' name='crocopay_api_key' value='$api_key' />";
}

function crocopay_search_engine_id_callback() {
    $search_engine_id = get_option('crocopay_search_engine_id');
    echo "<input type='text' name='crocopay_search_engine_id' value='$search_engine_id' />";
}


